package com.ejie.ab04b.service;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.TipoCambio;
import com.ejie.ab04b.dao.CoordinadorObraDao;
import com.ejie.ab04b.dao.HistCambiosAperturasDao;
import com.ejie.ab04b.model.ComunicacionApertura;
import com.ejie.ab04b.model.CoordinadorObra;
import com.ejie.ab04b.model.HistCambiosAperturas;
import com.ejie.ab04b.util.HistCambiosAperturasUtil;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0484s00ServiceImpl generated by UDA, 20-feb-2017 12:41:54.
 * 
 * @author UDA
 */

@Service(value = "coordinadorObraService")
public class CoordinadorObraServiceImpl implements CoordinadorObraService {

	@Autowired
	private CoordinadorObraDao ab0484s00Dao;

	@Autowired
	private HistCambiosAperturasDao histCambiosAperturasDao;

	/**
	 * Inserts a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CoordinadorObra add(CoordinadorObra ab0484s00) {
		return this.ab0484s00Dao.add(ab0484s00);
	}

	/**
	 * Updates a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CoordinadorObra update(CoordinadorObra ab0484s00) {
		return this.ab0484s00Dao.update(ab0484s00);
	}

	/**
	 * Finds a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the coordinador obra
	 */
	public CoordinadorObra find(CoordinadorObra ab0484s00) {
		return (CoordinadorObra) this.ab0484s00Dao.find(ab0484s00);
	}

	/**
	 * Finds a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @return the list
	 */
	public List<CoordinadorObra> findCoordinadorMaxFecAlta(
			CoordinadorObra ab0484s00) {
		return (List<CoordinadorObra>) this.ab0484s00Dao
				.findCoordinadorMaxFecAlta(ab0484s00);
	}

	/**
	 * Deletes a single row in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(CoordinadorObra ab0484s00) {
		this.ab0484s00Dao.remove(ab0484s00);
	}

	/**
	 * Finds a list of rows in the Ab0484s00 table.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0484s00>
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<CoordinadorObra> findAll(CoordinadorObra ab0484s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<CoordinadorObra>) this.ab0484s00Dao.findAll(ab0484s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0484s00 table using like.
	 * 
	 *  ab0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0484s00>
	 *
	 * @param ab0484s00 the ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<CoordinadorObra> findAllLike(CoordinadorObra ab0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<CoordinadorObra>) this.ab0484s00Dao.findAllLike(ab0484s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(CoordinadorObra filterAb0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0484s00Dao.removeMultiple(filterAb0484s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0484s00>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<CoordinadorObra> filter(
			CoordinadorObra filterAb0484s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<CoordinadorObra> listaAb0484s00 = this.ab0484s00Dao.findAllLike(
				filterAb0484s00, jqGridRequestDto, false);
		Long recordNum = this.ab0484s00Dao.findAllLikeCount(
				filterAb0484s00 != null ? filterAb0484s00
						: new CoordinadorObra(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<CoordinadorObra>> reorderSelection = this.ab0484s00Dao
					.reorderSelection(filterAb0484s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<CoordinadorObra>(jqGridRequestDto,
					recordNum, listaAb0484s00, reorderSelection);
		}
		return new JQGridResponseDto<CoordinadorObra>(jqGridRequestDto,
				recordNum, listaAb0484s00);
	}

	/**
	 * Searches rows in the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  searchAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param searchAb0484s00 the search ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<CoordinadorObra>> search(
			CoordinadorObra filterAb0484s00, CoordinadorObra searchAb0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0484s00Dao.search(filterAb0484s00, searchAb0484s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(CoordinadorObra filterAb0484s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0484s00Dao.reorderSelection(filterAb0484s00,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Finder method in the hierarchical the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<JerarquiaDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<CoordinadorObra>> jerarquia(
			CoordinadorObra filterAb0484s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		List<JerarquiaDto<CoordinadorObra>> listaAb0484s00 = this.ab0484s00Dao
				.findAllLikeJerarquia(filterAb0484s00, jqGridRequestDto);
		Long recordNum = this.ab0484s00Dao.findAllLikeCountJerarquia(
				filterAb0484s00, jqGridRequestDto);
		return new JQGridResponseDto<JerarquiaDto<CoordinadorObra>>(
				jqGridRequestDto, recordNum, listaAb0484s00);
	}

	/**
	 * Finder method for siblings rows in the hierarchical the Ab0484s00 table.
	 * 
	 *  filterAb0484s00
	 *            Ab0484s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  JQGridResponseDto<JerarquiaDto<Ab0484s00>>
	 *
	 * @param filterAb0484s00 the filter ab 0484 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<JerarquiaDto<CoordinadorObra>> jerarquiaChildren(
			CoordinadorObra filterAb0484s00, JQGridRequestDto jqGridRequestDto) {
		JQGridResponseDto<JerarquiaDto<CoordinadorObra>> jqGridResponseDto = new JQGridResponseDto<JerarquiaDto<CoordinadorObra>>();
		jqGridResponseDto.addAdditionalParam(JQGridResponseDto.CHILDREN,
				this.ab0484s00Dao.findAllChild(filterAb0484s00,
						jqGridRequestDto));
		return jqGridResponseDto;
	}

	/* (non-Javadoc)
	 * @see com.ejie.ab04b.service.CoordinadorObraService#modificarHistorico(com.ejie.ab04b.model.CoordinadorObra, com.ejie.ab04b.model.CoordinadorObra, com.ejie.ab04b.model.ComunicacionApertura)
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void modificarHistorico(CoordinadorObra coordinadorOLD,
			CoordinadorObra coordinadorNEW, ComunicacionApertura apertura) {

		String coordinadorOldStr = HistCambiosAperturasUtil
				.concatenarCampos(coordinadorOLD);
		String coordinadorNewStr = HistCambiosAperturasUtil
				.concatenarCampos(coordinadorNEW);

		HistCambiosAperturas histCambioAperturas = new HistCambiosAperturas();
		histCambioAperturas.setIdape087(apertura.getIdape056());
		if (apertura.getMigrado056() != null
				&& Constantes.VALUE_SI.equals(apertura.getMigrado056())) {
			histCambioAperturas.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
		} else {
			histCambioAperturas.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N);
		}

		histCambioAperturas.setRegoriginal087(coordinadorOldStr);
		histCambioAperturas.setRegmidificaciones087(coordinadorNewStr);
		histCambioAperturas.setFecmodif087(new Date());
		histCambioAperturas.setTipocambio087(TipoCambio.COORD_EJEC_OBRA
				.getCodigo());

		this.histCambiosAperturasDao.add(histCambioAperturas);

	}

	/**
	 * Devuelve el numero de Coordinadores de Obra.
	 * 
	 *  coordinador
	 *            CoordinadorObra
	 *  long
	 *
	 * @param coordinador the coordinador
	 * @return the long
	 */
	public long contarCoordeinadoresObra(CoordinadorObra coordinador) {
		return this.ab0484s00Dao.findAllCount(coordinador);
	}

	/**
	 * Devuelve el numero de Coordinadores de Proyecto.
	 * 
	 *  coordinador
	 *            CoordinadorObra
	 *  long
	 *
	 * @param coordinador the coordinador
	 * @return the long
	 */
	public long contarCoordeinadoresProyecto(CoordinadorObra coordinador) {
		return this.ab0484s00Dao.findAllCount(coordinador);
	}

}
